<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Form\Component as Form;

$request = Request::instance();
$form = new Form( Form::Storage_Field );

?>

<div class="ulz-modal-container ulz-scrollbar">
    <div class="ulz-reviews-form">
        <form class="ulz-form" autocomplete="off">
            <div class="ulz-grid">

                <?php

                    $form->render([
                        'type' => 'hidden',
                        'id' => 'comment_id',
                        'value' => $request->get('comment_id'),
                    ]);

                    $form->render([
                        'type' => 'textarea',
                        'id' => 'comment',
                        'name' => esc_html__( 'Enter your comment', 'utillz-core' ),
                    ]);

                ?>

            </div>
        </form>

    </div>

    <span class="ulz--icon ulz-none">
        <div class="ulz-text-center">
            <i class="fas fa-check"></i>
            <p><?php esc_html_e( 'Your reply was sent successfully', 'utillz-core' ); ?></p>
        </div>
    </span>

</div>

<div class="ulz-modal-footer ulz--top-border ulz-text-center">
    <a href="#" class="ulz-button ulz-button-accent ulz-modal-button" id="ulz-review-submit-reply">
        <span><?php esc_html_e( 'Submit Comment', 'utillz-core' ); ?></span>
        <?php Ucore()->preloader(); ?>
    </a>
</div>
